//
//  MCLicenseSupport.h
//  MCLicensing
//
//  Created by Michael Clark on 07/12/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>

// This source is the underlying support calls to make MCLicense happen.
// This API is all C based in the hopes of thwarting crackers
// This code was written while working on the big Daylite 3.9 PG migration and is what is used for license management - no longer the classes in this framework.




// This structure is used to pass information about a license around - generally from the validate license function

typedef struct _MCLicenseComponents {
	NSString*          productCode; // The product code of the license
	NSString*          versionString; // The version string of the license
	NSCalendarDate*    productExpiry; // When the license should stop allowing the product to work
	NSCalendarDate*    licenseExpiry; // When the license should no longer be allowed to be entered - not used/enforced
	NSNumber*          numberOfUsers; // How many users are licensed by the license
	int                featureMask;
} MCLicenseComponents;

// Main API - 1 call to validate the license
extern BOOL MCLicenseValidate(NSString* license_string, NSString* serial_string, MCLicenseComponents* components);

